-- Name: BSU_main
-- Author: Chissel

source(g_currentModDirectory .. "src/BSU_bunkerSiloOverwrites.lua")

source(g_currentModDirectory .. "src/BSU_addFillTypes.lua")
source(g_currentModDirectory .. "src/BSU_addHeightTypes.lua")

source(g_currentModDirectory .. "src/BSU_bunkerSiloExtension.lua")

source(g_currentModDirectory .. "src/events/BSU_reopenCoverEvent.lua")
source(g_currentModDirectory .. "src/events/BSU_closeCoverEvent.lua")
source(g_currentModDirectory .. "src/events/BSU_clearAreaEvent.lua")
source(g_currentModDirectory .. "src/events/BSU_changeCoverEvent.lua")

local function addBunkerSiloExtension()
    BunkerSilo.registerSavegameXMLPaths = Utils.appendedFunction(BunkerSilo.registerSavegameXMLPaths, BSU_bunkerSiloExtension.registerSavegameXMLPaths)
    BunkerSilo.saveToXMLFile = Utils.appendedFunction(BunkerSilo.saveToXMLFile, BSU_bunkerSiloExtension.saveToXMLFile)
    BunkerSilo.loadFromXMLFile = Utils.prependedFunction(BunkerSilo.loadFromXMLFile, BSU_bunkerSiloExtension.loadFromXMLFile)
    BunkerSilo.readStream = Utils.appendedFunction(BunkerSilo.readStream, BSU_bunkerSiloExtension.readStream)
    BunkerSilo.writeStream = Utils.appendedFunction(BunkerSilo.writeStream, BSU_bunkerSiloExtension.writeStream)
end

local function init()
    addBunkerSiloExtension()

    BunkerSilo.setState = Utils.overwrittenFunction(BunkerSilo.setState, BSU_bunkerSiloOverwrites.setState)
    BunkerSilo.update = Utils.appendedFunction(BunkerSilo.update, BSU_bunkerSiloOverwrites.update)

    FillTypeManager.loadMapData = Utils.appendedFunction(FillTypeManager.loadMapData, BSU_addFillTypes.loadMapData)
    DensityMapHeightManager.loadMapData = Utils.appendedFunction(DensityMapHeightManager.loadMapData, BSU_addHeightTypes.loadMapData)
end

init()