﻿--[[ act 

Author: 		HoFFi (modding-welt.com)
Remarks:		animations are limited to 10 for the current state


Description: 	script for activating xml-defined animation with user-defined input keys

Version: 		1.0.0.0

Changelog: 		2021-06-06 	- draft version
				2021-07-09	- first ready-to-use version
				2021-12-30	- converted to FS22 and improved some things


--------------------------------------------------------------------------------------------------


]]


act = {};

act.modDir = g_currentModDirectory;
act.currentModName = g_currentModName;

function act.prerequisitesPresent(specializations)
    return true; 
end;

function act.registerEventListeners(vehicleType)
	for _, spec in pairs({"onLoad", "onRegisterActionEvents", "actionEventfunction_anim1", "actionEventfunction_anim2", "actionEventfunction_anim3", "actionEventfunction_anim4", "actionEventfunction_anim5", "actionEventfunction_anim6", "actionEventfunction_anim7", "actionEventfunction_anim8", "actionEventfunction_anim9", "actionEventfunction_anim10"}) do
		SpecializationUtil.registerEventListener(vehicleType, spec, act)
	end
end

function act.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim1", act.actionEventfunction_anim1)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim2", act.actionEventfunction_anim2)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim3", act.actionEventfunction_anim3)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim4", act.actionEventfunction_anim4)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim5", act.actionEventfunction_anim5)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim6", act.actionEventfunction_anim6)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim7", act.actionEventfunction_anim7)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim8", act.actionEventfunction_anim8)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim9", act.actionEventfunction_anim9)
    SpecializationUtil.registerFunction(vehicleType, "actionEventfunction_anim10", act.actionEventfunction_anim10)
end

function act:onLoad(savegame)
	local schema = Vehicle.xmlSchema
    schema:setXMLSpecializationType("act")
	
	print("Info: act loaded to: " .. act.currentModName)
	
	schema:register(XMLValueType.STRING, "vehicle.act#anim1", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim2", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim3", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim4", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim5", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim6", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim7", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim8", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim9", "Animation name")
	schema:register(XMLValueType.STRING, "vehicle.act#anim10", "Animation name")
	
	
	self.act = {}
	self.act.anim1 = self.xmlFile:getValue("vehicle.act#anim1")
	self.act.anim2 = self.xmlFile:getValue("vehicle.act#anim2")
	self.act.anim3 = self.xmlFile:getValue("vehicle.act#anim3")
	self.act.anim4 = self.xmlFile:getValue("vehicle.act#anim4")
	self.act.anim5 = self.xmlFile:getValue("vehicle.act#anim5")
	self.act.anim6 = self.xmlFile:getValue("vehicle.act#anim6")
	self.act.anim7 = self.xmlFile:getValue("vehicle.act#anim7")
	self.act.anim8 = self.xmlFile:getValue("vehicle.act#anim8")
	self.act.anim9 = self.xmlFile:getValue("vehicle.act#anim9")
	self.act.anim10 = self.xmlFile:getValue("vehicle.act#anim10")
end;

function act:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
        local spec = self.spec_cylindered
        --self:clearActionEventsTable(spec.actionEvents)

        if isActiveForInputIgnoreSelection then
		
			if self.act.anim1 ~= nil then
				local _, actionEventId1 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim1, self, act.actionEventfunction_anim1, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId1, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId1, g_i18n:getText("input_function_anim1"))
			end
			if self.act.anim2 ~= nil then
				local _, actionEventId2 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim2, self, act.actionEventfunction_anim2, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId2, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId2, g_i18n:getText("input_function_anim2"))
			end
			if self.act.anim3 ~= nil then	
				local_, actionEventId3 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim3, self, act.actionEventfunction_anim3, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId3, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId3, g_i18n:getText("input_function_anim3"))
			end
			if self.act.anim4 ~= nil then	
				local_, actionEventId4 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim4, self, act.actionEventfunction_anim4, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId4, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId4, g_i18n:getText("input_function_anim4"))
			end
			if self.act.anim5 ~= nil then	
				local_, actionEventId5 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim5, self, act.actionEventfunction_anim5, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId5, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId5, g_i18n:getText("input_function_anim5"))
			end
			if self.act.anim6 ~= nil then	
				local_, actionEventId6 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim6, self, act.actionEventfunction_anim6, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId6, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId6, g_i18n:getText("input_function_anim6"))
			end
			if self.act.anim7 ~= nil then	
				local _, actionEventId7 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim7, self, act.actionEventfunction_anim7, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId7, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId7, g_i18n:getText("input_function_anim7"))
			end
			if self.act.anim8 ~= nil then	
				local _, actionEventId8 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim8, self, act.actionEventfunction_anim8, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId8, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId8, g_i18n:getText("input_function_anim8"))
			end
			if self.act.anim9 ~= nil then	
				local _, actionEventId9 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim9, self, act.actionEventfunction_anim9, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId9, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId9, g_i18n:getText("input_function_anim9"))
			end
			if self.act.anim10 ~= nil then	
				local _, actionEventId10 = self:addPoweredActionEvent(spec.actionEvents, InputAction.function_anim10, self, act.actionEventfunction_anim10, false, true, false, true, nil)
				g_inputBinding:setActionEventTextPriority(actionEventId10, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventText(actionEventId10, g_i18n:getText("input_function_anim10"))
			end
        end
    end

end

function act.actionEventfunction_anim1(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim1) == false then
		if self:getAnimationTime(self.act.anim1) == 1 then
			self:playAnimation(self.act.anim1, -1, self:getAnimationTime(self.act.anim1), true)
		else
			self:playAnimation(self.act.anim1, 1, self:getAnimationTime(self.act.anim1), true)
		end
	else
		self:stopAnimation(self.act.anim1, true)
	end
end

function act.actionEventfunction_anim2(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim2) == false then
		if self:getAnimationTime(self.act.anim2) == 1 then
			self:playAnimation(self.act.anim2, -1, self:getAnimationTime(self.act.anim2), true)
		else
			self:playAnimation(self.act.anim2, 1, self:getAnimationTime(self.act.anim2), true)
		end
	else
		self:stopAnimation(self.act.anim2, true)
	end
end

function act.actionEventfunction_anim3(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim3) == false then
		if self:getAnimationTime(self.act.anim3) == 1 then
			self:playAnimation(self.act.anim3, -1, self:getAnimationTime(self.act.anim3), true)
		else
			self:playAnimation(self.act.anim3, 1, self:getAnimationTime(self.act.anim3), true)
		end
	else
		self:stopAnimation(self.act.anim3, true)
	end
end

function act.actionEventfunction_anim4(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim4) == false then
		if self:getAnimationTime(self.act.anim4) == 1 then
			self:playAnimation(self.act.anim4, -1, self:getAnimationTime(self.act.anim4), true)
		else
			self:playAnimation(self.act.anim4, 1, self:getAnimationTime(self.act.anim4), true)
		end
	else
		self:stopAnimation(self.act.anim4, true)
	end
end

function act.actionEventfunction_anim5(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim5) == false then
		if self:getAnimationTime(self.act.anim5) == 1 then
			self:playAnimation(self.act.anim5, -1, self:getAnimationTime(self.act.anim5), true)
		else
			self:playAnimation(self.act.anim5, 1, self:getAnimationTime(self.act.anim5), true)
		end
	else
		self:stopAnimation(self.act.anim5, true)
	end
end

function act.actionEventfunction_anim6(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim6) == false then
		if self:getAnimationTime(self.act.anim6) == 1 then
			self:playAnimation(self.act.anim6, -1, self:getAnimationTime(self.act.anim6), true)
		else
			self:playAnimation(self.act.anim6, 1, self:getAnimationTime(self.act.anim6), true)
		end
	else
		self:stopAnimation(self.act.anim6, true)
	end
end

function act.actionEventfunction_anim7(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim7) == false then
		if self:getAnimationTime(self.act.anim7) == 1 then
			self:playAnimation(self.act.anim7, -1, self:getAnimationTime(self.act.anim7), true)
		else
			self:playAnimation(self.act.anim7, 1, self:getAnimationTime(self.act.anim7), true)
		end
	else
		self:stopAnimation(self.act.anim7, true)
	end
end

function act.actionEventfunction_anim8(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim8) == false then
		if self:getAnimationTime(self.act.anim8) == 1 then
			self:playAnimation(self.act.anim8, -1, self:getAnimationTime(self.act.anim8), true)
		else
			self:playAnimation(self.act.anim8, 1, self:getAnimationTime(self.act.anim8), true)
		end
	else
		self:stopAnimation(self.act.anim8, true)
	end
end

function act.actionEventfunction_anim9(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim9) == false then
		if self:getAnimationTime(self.act.anim9) == 1 then
			self:playAnimation(self.act.anim9, -1, self:getAnimationTime(self.act.anim9), true)
		else
			self:playAnimation(self.act.anim9, 1, self:getAnimationTime(self.act.anim9), true)
		end
	else
		self:stopAnimation(self.act.anim9, true)
	end
end

function act.actionEventfunction_anim10(self, actionName, inputValue, callbackState, isAnalog)
	if self:getIsAnimationPlaying(self.act.anim10) == false then
		if self:getAnimationTime(self.act.anim10) == 1 then
			self:playAnimation(self.act.anim10, -1, self:getAnimationTime(self.act.anim10), true)
		else
			self:playAnimation(self.act.anim10, 1, self:getAnimationTime(self.act.anim10), true)
		end
	else
		self:stopAnimation(self.act.anim10, true)
	end
end