-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thPFConfig
THPHMap = {}
local THPHMap_mt = THUtils.createClass(THPHMap)
local debugFlagId = THDebugUtil.createFlagId("THPHMap")
THPHMap.debugFlagId = debugFlagId
THPHMap.DATA_KEY = thMain.modName .. ".thPHMap"
local function initScript()
    local pfData = thMain.precisionFarming
    if pfData ~= nil and pfData.isFound then
        local PHMap = pfData.modEnv.PHMap
        THUtils.setFunctionHook(PHMap, "loadFromXML", false, false, nil, THPHMap.gInj_loadFromXML)
    end
end
local function getCustomData(parentEnv)
    if parentEnv ~= nil then
        return THUtils.getDataTable(parentEnv, THPHMap.DATA_KEY)
    end
end
THPHMap.getCustomData = getCustomData
function THPHMap.new(parentEnv, customMt)
    customMt = customMt or THPHMap_mt
    if THUtils.argIsValid(type(parentEnv) == THValueType.TABLE, "parentEnv", parentEnv)
        and THUtils.argIsValid(type(customMt) == THValueType.TABLE, "customMt", customMt)
    then
        local self = getCustomData(parentEnv)
        if self == nil then
            self = THUtils.createDataTable(parentEnv, THPHMap.DATA_KEY, customMt)
            if self ~= nil then
                THUtils.setFunctionHook(parentEnv, "getLimeUsageByStateChange", false, false, self, THPHMap.inj_getLimeUsageByStateChange)
            end
        end
        return self
    end
end
function THPHMap.setUsageSprayType(self, sprayType)
    local lastUsageSprayType = self.usageSprayType
    if sprayType == nil then
        self.usageSprayType = nil
    else
        local xtSprayTypeData = thMain:getExtendedSprayType(sprayType)
        if xtSprayTypeData ~= nil
            and xtSprayTypeData.group == THPFConfig.SPRAY_TYPE_GROUP.LIME
        then
            self.usageSprayType = xtSprayTypeData.sprayTypeIndex
        end
    end
    return lastUsageSprayType
end
function THPHMap.inj_getLimeUsageByStateChange(self, superFunc, parentEnv, ...)
    local function appendFunc(rUsage, ...)
        if type(rUsage) == THValueType.NUMBER and rUsage > 0 then
            THUtils.call(function()
                if self.parent == parentEnv and self.usageSprayType ~= nil then
                    local xtSprayTypeData = thMain:getExtendedSprayType(self.usageSprayType)
                    if xtSprayTypeData ~= nil then
                        rUsage = rUsage * (xtSprayTypeData.usageFactor or 1)
                        if THDebugUtil.getIsEnabled(debugFlagId, THDebugLevel.UPDATE) then
                            THUtils.displayMsg("THPHMap: Lime usage information:")
                            THUtils.displayMsg("- usage fill type: %s", xtSprayTypeData.fillTypeId)
                            if xtSprayTypeData.usageFactor ~= nil then
                                THUtils.displayMsg("- usage factor: %s", xtSprayTypeData.usageFactor)
                            end
                        end
                    end
                end
            end)
        end
        return rUsage, ...
    end
    return appendFunc(superFunc(parentEnv, ...))
end
function THPHMap.gInj_loadFromXML(superFunc, parentEnv, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile > 0))
        and xmlKey ~= nil and xmlKey ~= ""
    then
        THUtils.call(function()
            local self = THPHMap.getCustomData(parentEnv)
            if self == nil then
                self = THPHMap.new(parentEnv)
            end
        end)
    end
    return superFunc(parentEnv, xmlFile, xmlKey, ...)
end
THUtils.call(initScript)