-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thPFConfig
local thMapTypeManager = thMain.thMapTypeManager
THLoadingStation = {}
THBuyingStation = {}
THLoadTrigger = {}
local function initScript()
    THUtils.setFunctionHook("LoadingStation", "load", false, false, nil, THLoadingStation.gInj_load)
    THUtils.setFunctionHook("BuyingStation", "load", false, false, nil, THBuyingStation.gInj_load)
    THUtils.setFunctionHook("LoadTrigger", "load", false, false, nil, THLoadTrigger.gInj_load)
end
function THLoadingStation.gInj_load(superFunc, parentEnv, rootNode, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile ~= 0))
        and type(xmlKey) == THValueType.STRING
    then
        THUtils.call(function()
            local fillTypeNames = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes")
            local fillTypeCategories = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = thMain:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                        THUtils.displayMsg("LoadingStation: updated fill types: %s", newFillTypeNames)
                    end
                    THUtils.setXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        THUtils.removeXMLProperty(xmlFile, xmlKey .. "#fillTypeCatgories")
                    end
                end
            end
        end)
    end
    return superFunc(parentEnv, rootNode, xmlFile, xmlKey, ...)
end
function THBuyingStation.gInj_load(superFunc, parentEnv, rootNode, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile ~= 0))
        and type(xmlKey) == THValueType.STRING
    then
        THUtils.call(function()
            local fillTypeXMLIndex = 0
            local stationFillTypes = {}
            local defaultPriceScale, defaultStatsName = nil, nil
            while true do
                local fillTypeKey = string.format("%s.fillType(%d)", xmlKey, fillTypeXMLIndex)
                if not THUtils.hasXMLProperty(xmlFile, fillTypeKey) then
                    break
                end
                local fillTypeName = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, fillTypeKey, "#name")
                local priceScale = THUtils.getXMLValue(xmlFile, XMLValueType.FLOAT, fillTypeKey, "#priceScale")
                local statsName = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, fillTypeKey, "#statsName")
                if fillTypeName ~= nil and fillTypeName ~= "" then
                    local thFillTypeData = thMapTypeManager:getFillType(fillTypeName)
                    local xtSprayTypeData = thMain:getExtendedSprayType(fillTypeName)
                    if thFillTypeData ~= nil and thFillTypeData ~= FillType.UNKNOWN
                        and (statsName ~= nil or priceScale ~= nil)
                    then
                        if priceScale ~= nil then
                            if defaultPriceScale == nil or xtSprayTypeData ~= nil then
                                defaultPriceScale = priceScale
                            end
                        end
                        if statsName ~= nil then
                            if defaultStatsName == nil or xtSprayTypeData ~= nil then
                                defaultStatsName = statsName
                            end
                        end
                        stationFillTypes[thFillTypeData.id] = {
                            priceScale = priceScale,
                            statsName = statsName
                        }
                    end
                end
                fillTypeXMLIndex = fillTypeXMLIndex + 1
            end
            local _, newFillTypeList = thMain:addExtendedSprayTypesToFillTypeList(stationFillTypes, nil, nil, true, true)
            if newFillTypeList ~= nil then
                for fillTypeId, newFillTypeData in pairs(newFillTypeList) do
                    local xtSprayTypeData = thMain:getExtendedSprayTypeByFillType(fillTypeId)
                    if xtSprayTypeData ~= nil and not xtSprayTypeData.isBaseType
                        and stationFillTypes[xtSprayTypeData.fillTypeId] == nil
                    then
                        local fillTypeKey = string.format("%s.fillType(%d)", xmlKey, fillTypeXMLIndex)
                        local priceScale = THUtils.getNoNil(newFillTypeData.priceScale, defaultPriceScale)
                        local statsName = THUtils.getNoNil(newFillTypeData.statsName, defaultStatsName)
                        if statsName ~= nil or priceScale ~= nil then
                            THUtils.setXMLValue(xmlFile, XMLValueType.STRING, fillTypeKey, "#name", xtSprayTypeData.fillTypeId)
                            if statsName ~= nil then
                                THUtils.setXMLValue(xmlFile, XMLValueType.STRING, fillTypeKey, "statsName", statsName)
                            end
                            if priceScale ~= nil then
                                THUtils.setXMLValue(xmlFile, XMLValueType.FLOAT, fillTypeKey, "#priceScale", priceScale)
                            end
                            if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                                THUtils.displayMsg("BuyingStation: added fillType %q", xtSprayTypeData.fillTypeId)
                                THUtils.displayMsg("- priceScale: %s", priceScale)
                                THUtils.displayMsg("- statsName: %s", statsName)
                            end
                            fillTypeXMLIndex = fillTypeXMLIndex + 1
                        end
                    end
                end
            end
        end)
    end
    return superFunc(parentEnv, rootNode, xmlFile, xmlKey, ...)
end
function THLoadTrigger.gInj_load(superFunc, parentEnv, rootNode, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile ~= 0))
        and type(xmlKey) == THValueType.STRING
    then
        THUtils.call(function()
            local fillTypeNames = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes")
            local fillTypeCategories = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = thMain:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                        THUtils.displayMsg("LoadTrigger: updated fill types: %s", newFillTypeNames)
                    end
                    THUtils.setXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        THUtils.removeXMLProperty(xmlFile, xmlKey .. "#fillTypeCategories")
                    end
                end
            end
        end)
    end
    return superFunc(parentEnv, rootNode, xmlFile, xmlKey, ...)
end
THUtils.call(initScript)