
--[[
    Authors: Modding-Welt, bm-modding
    Support: Internet forum of "Modding-Welt"
    Discord: @peter_ah
]]

Unimog = {}

function Unimog.prerequisitesPresent(specializations)
    return true
end

function Unimog.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onStopMotor", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onTurnLightStateChanged", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", Unimog)
end

function Unimog:initSpecialization()
    local schema = Vehicle.xmlSchema
    schema:register(XMLValueType.STRING, "vehicle.unimog.tippingWarningLight#node", "Tipping")
    schema:register(XMLValueType.STRING, "vehicle.unimog.trailer2TurnWarningLight#node", "Trailer2")
    schema:register(XMLValueType.STRING, "vehicle.unimog.handbrakeWarningLight#node", "Handbrake")
    schema:register(XMLValueType.STRING, "vehicle.unimog.differentialWarningLight#node", "Differential")
    schema:register(XMLValueType.STRING, "vehicle.unimog.fourWheelDriveWarningLight#node", "4WD")
end

function Unimog:onPreLoad(savegame)
    -- Change the standard horn sound to airhorn sound
    local configurationId = Utils.getNoNil(self.configurations["design3"], 0)
    if configurationId == 4 or configurationId == 5 or configurationId == 6 then
        removeXMLProperty(self.externalSoundsFile.handle, "sounds.honk.sound#file")
        setXMLString(self.externalSoundsFile.handle, "sounds.honk.sound#file", "sounds/u1600_horn_loop.ogg")
    end
end

function Unimog:onLoad(savegame)
    local valueTippingNode = self.xmlFile:getValue("vehicle.unimog.tippingWarningLight#node")
    local valueTrailer2Node = self.xmlFile:getValue("vehicle.unimog.trailer2TurnWarningLight#node")
    local valueHandbrakeNode = self.xmlFile:getValue("vehicle.unimog.handbrakeWarningLight#node")
    local valueDifferentialNode = self.xmlFile:getValue("vehicle.unimog.differentialWarningLight#node")
    local value4wdNode = self.xmlFile:getValue("vehicle.unimog.fourWheelDriveWarningLight#node")

    self.tippingWarningLightNode = I3DUtil.indexToObject(self.components, valueTippingNode, self.i3dMappings)
    self.trailer2TurnWarningLightNode = I3DUtil.indexToObject(self.components, valueTrailer2Node, self.i3dMappings)
    self.handbrakeWarningLightNode = I3DUtil.indexToObject(self.components, valueHandbrakeNode, self.i3dMappings)
    self.differentialWarningLightNode = I3DUtil.indexToObject(self.components, valueDifferentialNode, self.i3dMappings)
    self.fourWheelDriveWarningLightNode = I3DUtil.indexToObject(self.components, value4wdNode, self.i3dMappings)

    setVisibility(self.handbrakeWarningLightNode, false)
    setVisibility(self.differentialWarningLightNode, false)
    setVisibility(self.fourWheelDriveWarningLightNode, false)

    self.turnLightAttachments = 0
    self.selfTrailer2 = nil
	self.isTippingWarningLightOn = false
end

function Unimog:onPostLoad(savegame)
    local configurationId = Utils.getNoNil(self.configurations["tireSound"], 0)
    if configurationId > 1 then  -- turns of the Unimog tire sound if tireSound script is activated
        self.spec_motorized.samples.retarder.indoorAttributes.volume = 0
        self.spec_motorized.samples.retarder.outdoorAttributes.volume = 0
    end
end

function Unimog:onStopMotor()
    setVisibility(self.handbrakeWarningLightNode, false)
    setVisibility(self.differentialWarningLightNode, false)
    setVisibility(self.fourWheelDriveWarningLightNode, false)
    setVisibility(self.tippingWarningLightNode, false)
end

function Unimog:onTurnLightStateChanged(state)
    --print("onTurnLightStateChanged")
    --print(state)
    local implementRet
    local turnLightAttachments = 0
    if state == 0 then
        setTranslation(self.trailer2TurnWarningLightNode, 0.032, 1.952, 1.119)
        turnLightAttachments = 0
        self.selfTrailer2 = nil
    else

        for _, implement in pairs(self:getAttachedImplements()) do
            if implement.object ~= nil then
                local vehicle = implement.object
                if vehicle.spec_lights ~= nil then
                    if vehicle.spec_lights.realLights ~= nil then
                        if vehicle.spec_lights.realLights.high ~= nil then
                            if vehicle.spec_lights.realLights.high.turnLightsLeft ~= nil then
                                if vehicle.spec_lights.realLights.high.turnLightsLeft[1] ~= nil then
                                    turnLightAttachments = turnLightAttachments + 1
                                    implementRet = implement
                                end
                            end
                        end
                    end
                end
            end
        end

        self.selfTrailer2 = nil
        if turnLightAttachments == 1 then
            for _, implement in pairs(implementRet.object:getAttachedImplements()) do
                if implement.object ~= nil then
                local vehicle = implement.object
                    if vehicle.spec_lights ~= nil then
                        if vehicle.spec_lights.realLights ~= nil then
                            if vehicle.spec_lights.realLights.high ~= nil then
                                if vehicle.spec_lights.realLights.high.turnLightsLeft ~= nil then
                                    if vehicle.spec_lights.realLights.high.turnLightsLeft[1] ~= nil then
                                        if vehicle.spec_lights.turnLightState ~= nil then
                                            self.selfTrailer2 = vehicle
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        if self.selfTrailer2 == nil then
            setTranslation(self.trailer2TurnWarningLightNode, 0.032, 1.952, 1.119)
            turnLightAttachments = 0
        end
    end
    self.turnLightAttachments = turnLightAttachments
end

function Unimog:onUpdateTick(dt)
  --  renderText(0.66, 0.16, 0.035, tostring(self.handbrakeWarningLightNode))
  if self:getIsMotorStarted() then

        local isTipping = false
        for _, implement in pairs(self:getAttachedImplements()) do
            if implement.object ~= nil and implement.object.getTipState ~= nil then
                if implement.object:getTipState() > 0 then
                    isTipping = true
                    --break -- reicht, wenn ein Anhänger kippt
                end
            end
        end

        if isTipping == false then
            setVisibility(self.tippingWarningLightNode, false)
        else
            setVisibility(self.tippingWarningLightNode, true)
        end


        local handbrakeVCA = false
        local differentialVCA = false
        local fourWheelDriveVCA = false
        if self.spec_vca ~= nil then
            if self.spec_vca.handbrake ~= nil and self.spec_vca.handbrake == true then
                handbrakeVCA = true
            end
            if self.spec_vca.diffManual ~= nil and self.spec_vca.diffManual == true then
                if self.spec_vca.diffLockFront ~= nil and self.spec_vca.diffLockFront == true then
                    differentialVCA = true
                end
                if self.spec_vca.diffLockBack ~= nil and self.spec_vca.diffLockBack == true then
                    differentialVCA = true
                end
                if self.spec_vca.diffLockAWD ~= nil and self.spec_vca.diffLockAWD == true then
                    fourWheelDriveVCA = true
                end
            end    
        end

        local handbrakeEV = false
        local differentialEV = false
        local fourWheelDriveEV = false  -- EV = Enhance Vehicle
        if self.vData ~= nil and self.vData.is ~= nil and self.vData.is[13] ~= nil then
            if self.vData.is[13] == true then
                handbrakeEV = true
            end
            if self.vData.is[1] == true or self.vData.is[2] == true then
                differentialEV = true
            end
            if self.vData.is[3] == 1 then
                fourWheelDriveEV = true
            end
        end
        
        if handbrakeVCA == true or handbrakeEV == true then
            setVisibility(self.handbrakeWarningLightNode, true)
        else
            local intensity, _, _, _ = getShaderParameter(self.handbrakeWarningLightNode, "lightIds0")
            if intensity > 0 then
                setVisibility(self.handbrakeWarningLightNode, false)
            end
        end
        if differentialVCA == true or differentialEV == true then
            setVisibility(self.differentialWarningLightNode, true)
        else
            local intensity, _, _, _ = getShaderParameter(self.differentialWarningLightNode, "lightIds0")
            if intensity > 0 then
                setVisibility(self.differentialWarningLightNode, false)
            end
        end
        if fourWheelDriveVCA == true or fourWheelDriveEV == true then
            setVisibility(self.fourWheelDriveWarningLightNode, true)
        else
            local intensity, _, _, _ = getShaderParameter(self.fourWheelDriveWarningLightNode, "lightIds0")
            if intensity > 0 then
                setVisibility(self.fourWheelDriveWarningLightNode, false)
            end
        end
     end

    if self.turnLightAttachments == 1 then
        if self.selfTrailer2.spec_lights.turnLightState == 0 then
            setTranslation(self.trailer2TurnWarningLightNode, 0.032, 1.952, 1.119)
            self.turnLightAttachments = 0
            self.selfTrailer2 = nil
        else
            setTranslation(self.trailer2TurnWarningLightNode, 0.465, 1.952, 1.119)
        end
    end
	
end
