SetRotorArmEvent = {}
local SetRotorArmEvent_mt = Class(SetRotorArmEvent, Event)

InitEventClass(SetRotorArmEvent, "SetRotorArmEvent")

function SetRotorArmEvent.emptyNew()
	local self = Event.new(SetRotorArmEvent_mt)

	return self
end

function SetRotorArmEvent.new(object, index, state)
	local self = SetRotorArmEvent.emptyNew()
	self.object = object
	self.index = index
	self.state = state

	return self
end

function SetRotorArmEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId)
	self.index = streamReadInt8(streamId)
	self.state = streamReadBool(streamId)

	self:run(connection)
end

function SetRotorArmEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object)
	streamWriteInt8(streamId, self.index)
	streamWriteBool(streamId, self.state)
end

function SetRotorArmEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRotorArmEvent.new(self.object, self.index, self.state), nil, connection, self.object)
	end
	
	if self.object ~= nil and self.object:getIsSynchronized() then
		self.object:setRotorArm(self.index, self.state, true)
	end
end

function SetRotorArmEvent.sendEvent(vehicle, index, state, noEventSend)
	if vehicle.spec_individualLowering ~= nil and (noEventSend == nil or noEventSend == false) then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRotorArmEvent.new(vehicle, index, state), nil, false, vehicle)
		else
			g_client:getServerConnection():sendEvent(SetRotorArmEvent.new(vehicle, index, state))
		end
	end
end
