--[[
    LockSteeringAxleEvent

    Multiplayer event for locking/unlocking the steering axles of a vehicle.

	@author: 		[LSFM] BayernGamers
	@date: 			13.11.2024
	@version:		1.0

	History:		v1.0 @13.11.2024 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License: 		This work is licensed under the Creative Commons Attribution-NoDerivs 4.0 International License (CC BY-ND 4.0).

					Terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage: 
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.

						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.

						Full License Text:
							The complete license text can be found at: https://creativecommons.org/licenses/by-nd/4.0/
]]

source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil

LockSteeringAxleEvent = {}
LockSteeringAxleEvent_mt = Class(LockSteeringAxleEvent, Event)

InitEventClass(LockSteeringAxleEvent, "LockSteeringAxleEvent")

function LockSteeringAxleEvent:emptyNew()
    local self = Event.new(LockSteeringAxleEvent_mt)
    return self
end

function LockSteeringAxleEvent.new(vehicle, lockSteeringAxle)
    local self = LockSteeringAxleEvent:emptyNew()
    self.vehicle = vehicle
    self.lockSteeringAxle = lockSteeringAxle

    return self
end

function LockSteeringAxleEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteBool(streamId, self.lockSteeringAxle)
end

function LockSteeringAxleEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.lockSteeringAxle = streamReadBool(streamId)
    self:run(connection)
end

function LockSteeringAxleEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end
    if self.vehicle ~= nil then
        self.vehicle.spec_lockSteeringAxle.lockSteeringAxle = self.lockSteeringAxle
        LockSteeringAxle.updateToggleLockSteeringAxleActionEvent(self.vehicle)
    end
end

function LockSteeringAxleEvent.sendEvent(vehicle, lockSteeringAxle, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(LockSteeringAxleEvent.new(vehicle, lockSteeringAxle), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(LockSteeringAxleEvent.new(vehicle, lockSteeringAxle))
        end
    end
end