--[[
MathUtil

Class that adds some math functions that seem not to be available in FS25.
	@author: 	[LSFM] BayernGamers
	@date: 		07.11.2024
	@version:	1.0

	History:	v1.0 @07.11.2024 - initial implementation in FS 22
				-------------------------------------------------------------------------------------------

    License: 	This work is licensed under the Creative Commons Attribution-NoDerivs 4.0 International License (CC BY-ND 4.0).

                Terms:
                    Attribution:
                        You must give appropriate credit to the original author when using this work.
                    No Derivatives:
                        You may not alter, transform, or build upon this work in any way.
                    Usage: 
                        The work may be used for personal and commercial purposes, provided it is not modified or adapted.

                    Additional Clause:
                        This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.

                    Full License Text:
                        The complete license text can be found at: https://creativecommons.org/licenses/by-nd/4.0/
]]

AdditionalMathUtil = {}

function AdditionalMathUtil.sign(x)
    if x > 0 then
        return 1
    elseif x < 0 then
        return -1
    else
        return 0
    end
end

function AdditionalMathUtil.clamp(value, minVal, maxVal)
	return math.min(math.max(value, minVal), maxVal)
end